library(xlsx)
library(ggplot2)
library(cowplot)

setwd("D:/SamCross_PhD/C1 - Ducks/Duck Data/REVISIONS_KINEMATICS/Pitch_ELL")

MA.Pitch <- read.xlsx("Mallard_Pitch_ELL.xlsx", sheetIndex = 1, header = FALSE)
AY.Pitch <- read.xlsx("Aylesbury_Pitch_ELL.xlsx", sheetIndex = 1, header = FALSE)
IR.Pitch <- read.xlsx("Runner_Pitch_ELL.xlsx", sheetIndex = 1, header = FALSE)

MA.ELL.Norm <- read.xlsx("Mallard_Pitch_ELL.xlsx", sheetIndex = 3, header = FALSE)
AY.ELL.Norm <- read.xlsx("Aylesbury_Pitch_ELL.xlsx", sheetIndex = 3, header = FALSE)
IR.ELL.Norm <- read.xlsx("Runner_Pitch_ELL.xlsx", sheetIndex = 3, header = FALSE)

MA.Hip <- read.xlsx("Mallard_Pitch_ELL.xlsx", sheetIndex = 4, header = FALSE)
AY.Hip <- read.xlsx("Aylesbury_Pitch_ELL.xlsx", sheetIndex = 4, header = FALSE)
IR.Hip <- read.xlsx("Runner_Pitch_ELL.xlsx", sheetIndex = 4, header = FALSE)

Combined <- data.frame(matrix(nrow = 90, ncol = 4))
colnames(Combined) <- c("Pitch", "ELL_Norm", "Breed", "Hip")
Combined$Pitch <- c(MA.Pitch[,1], AY.Pitch[,1], IR.Pitch[,1])
Combined$ELL_Norm <- c(MA.ELL.Norm[,1], AY.ELL.Norm[,1], IR.ELL.Norm[,1])
Combined$Hip <- c(MA.Hip[,1], AY.Hip[,1], IR.Hip[,1])
Breed <- c(rep("MA", 30),rep("AY", 30),rep("IR", 30))
Combined$Breed <- Breed

Pitch.ELL.Plot <- ggplot(data = Combined, aes(x = Pitch, y = ELL_Norm)) +
  geom_point(aes(color = Breed, shape = Breed)) +
  labs(x = "Trunk Pitch (\u00B0)", y = "Relative Hip Height") +
  ylim(0.65, 0.9) +
  stat_smooth(method="lm", se=FALSE, colour = "black") +
  #stat_smooth(data = Combined[1:30,], method="lm", se=FALSE, colour = "lightyellow3") +
  #stat_smooth(data = Combined[31:60,], method="lm", se=FALSE, colour = "sienna3") +
  stat_smooth(data = Combined[61:90,], method="lm", se=FALSE, colour = "skyblue4") +
  scale_colour_manual(values=c("sienna3", "skyblue4", "lightyellow3")) +
  scale_shape_manual(values=c(16, 18, 15)) +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), 
        panel.grid.minor = element_blank(), 
        panel.background = element_blank(), 
        axis.line = element_line(colour = "black"),
        panel.border = element_rect(colour = "black", fill=NA))


Pitch.Hip.Plot <- ggplot(data = Combined, aes(x = Pitch, y = Hip)) +
  geom_point(aes(color = Breed, shape = Breed)) +
  labs(x = "Trunk Pitch (\u00B0)", y = "Hip Angle (\u00B0)") +
  ylim(0, 80) +
  stat_smooth(method="lm", se=FALSE, colour = "black") +
  stat_smooth(data = Combined[1:30,], method="lm", se=FALSE, colour = "lightyellow3") +
  stat_smooth(data = Combined[31:60,], method="lm", se=FALSE, colour = "sienna3") +
  stat_smooth(data = Combined[61:90,], method="lm", se=FALSE, colour = "skyblue4") +
  scale_colour_manual(values=c("sienna3", "skyblue4", "lightyellow3")) +
  scale_shape_manual(values=c(16, 18, 15)) +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), 
        panel.grid.minor = element_blank(), 
        panel.background = element_blank(), 
        axis.line = element_line(colour = "black"),
        panel.border = element_rect(colour = "black", fill=NA))


tiff(filename = "ELL_Pitch.tif", width = 166, height = 166, units = "mm", res = 600, compression = "lzw") #166x166*2 or 166x166*1.5

plot.new()

plot_grid(Pitch.ELL.Plot,
          Pitch.Hip.Plot,
          ncol = 1, 
          labels = c("A", "B"))

dev.off()

###STATS

Pitch.ELL.Duck <- lm(ELL_Norm ~ Pitch, data = Combined)
summary(Pitch.ELL.Duck)

Pitch.ELL.MA <- lm(ELL_Norm ~ Pitch, data = Combined[1:30,])
summary(Pitch.ELL.MA)

Pitch.ELL.AY <- lm(ELL_Norm ~ Pitch, data = Combined[31:60,])
summary(Pitch.ELL.AY)

Pitch.ELL.IR <- lm(ELL_Norm ~ Pitch, data = Combined[61:90,])
summary(Pitch.ELL.IR)

Pitch.Hip.Duck <- lm(Hip ~ Pitch, data = Combined)
summary(Pitch.Hip.Duck)

Pitch.Hip.MA <- lm(Hip ~ Pitch, data = Combined[1:30,])
summary(Pitch.Hip.MA)

Pitch.Hip.AY <- lm(Hip ~ Pitch, data = Combined[31:60,])
summary(Pitch.Hip.AY)

Pitch.Hip.IR <- lm(Hip ~ Pitch, data = Combined[61:90,])
summary(Pitch.Hip.IR)